<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\TruckController;
use App\Http\Controllers\DriverController;
use App\Http\Controllers\FuelPurchaseController;
use App\Http\Controllers\TripController; 
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\MaterialController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\ExpenseController; // Tambahkan import ini
use App\Http\Controllers\AnnouncementController;
use App\Http\Controllers\ManualTripCountController; // Tambahkan import ini
use App\Http\Controllers\ReportController; // Tambahkan import ini untuk ReportController
use App\Http\Controllers\IncomeController; // Tambahkan import ini juga karena digunakan di routes
use Illuminate\Support\Facades\Route;
use App\Models\Driver;
use App\Models\Truck;

Route::get('/', function () {
    return redirect()->route('login');
});

require __DIR__.'/auth.php';

Route::get('/dashboard', [App\Http\Controllers\DashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    // Manajemen Armada
    Route::resource('trucks', TruckController::class);
    Route::resource('drivers', DriverController::class);
    Route::resource('fuel-purchases', FuelPurchaseController::class);
    
    // API untuk mendapatkan driver berdasarkan truck
    Route::get('/api/drivers-by-truck/{truck}', function($truck) {
        return Driver::where('truck_id', $truck)->get();
    });

    // Trips Routes
    Route::resource('trips', TripController::class);
    
    // Di dalam grup middleware auth, tambahkan:
    Route::resource('projects', ProjectController::class);
    Route::resource('materials', MaterialController::class);
    Route::resource('clients', ClientController::class);
    Route::resource('expenses', ExpenseController::class); // Tambahkan route resource untuk expenses
    Route::resource('announcements', AnnouncementController::class);
    
    // Routes untuk laporan
    // Ganti route berikut:
    Route::get('/reports/trips', function() {
        return view('reports.trips');
    })->name('reports.trips');
    
    Route::get('/reports/fuel', function() {
        return view('reports.fuel');
    })->name('reports.fuel');
    
    // Dengan route yang menggunakan controller:
    Route::get('/reports/trips', [ReportController::class, 'trips'])->name('reports.trips');
    Route::get('/reports/fuel', [ReportController::class, 'fuel'])->name('reports.fuel');
    
    Route::get('/reports/expenses', function() {
        return view('reports.expenses');
    })->name('reports.expenses');
    
    Route::get('/reports/projects', function() {
        return view('reports.projects');
    })->name('reports.projects');
});

// Settings Routes (accessible by authenticated users with access-settings permission)
Route::middleware(['auth', 'permission:access-settings'])->group(function () {
    // Settings routes
    Route::get('/settings', [App\Http\Controllers\SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings', [App\Http\Controllers\SettingController::class, 'update'])->name('settings.update');
    Route::post('/settings/reset', [App\Http\Controllers\SettingController::class, 'reset'])->name('settings.reset');
    Route::post('/settings/test-email', [App\Http\Controllers\SettingController::class, 'testEmail'])->name('settings.test-email');
    Route::get('/settings/export', [App\Http\Controllers\SettingController::class, 'export'])->name('settings.export');
    Route::post('/settings/import', [App\Http\Controllers\SettingController::class, 'import'])->name('settings.import');
    Route::get('/settings/update-timezone-to-select', [App\Http\Controllers\SettingController::class, 'updateTimezoneToSelect'])->name('settings.update-timezone-to-select');
});

// User, Role, and Permission management routes (accessible by users with appropriate permissions)
Route::middleware(['auth', 'permission:manage-users'])->group(function () {
    Route::resource('users', App\Http\Controllers\UserController::class);
});

Route::middleware(['auth', 'permission:manage-roles'])->group(function () {
    Route::resource('roles', App\Http\Controllers\RoleController::class);
});

Route::middleware(['auth', 'permission:manage-permissions'])->group(function () {
    Route::resource('permissions', App\Http\Controllers\PermissionController::class);
});

// Routes untuk retase manual
Route::middleware(['auth'])->group(function () {
    Route::get('/drivers/{driver}/manual-trip-counts/create', [ManualTripCountController::class, 'create'])
        ->name('drivers.manual-trip-counts.create');
    Route::post('/drivers/{driver}/manual-trip-counts', [ManualTripCountController::class, 'store'])
        ->name('drivers.manual-trip-counts.store');
    Route::get('/drivers/{driver}/manual-trip-counts/history', [ManualTripCountController::class, 'history'])
        ->name('drivers.manual-trip-counts.history');
});

// Routes untuk manajemen keuangan
// Tambahkan di bagian route expenses
Route::middleware(['auth'])->group(function () {
    // Financial Management Routes
    
    // Route untuk ekspor pendapatan (pindahkan ke atas)
    Route::get('/incomes/export', [IncomeController::class, 'export'])->name('incomes.export');
    
    Route::resource('incomes', IncomeController::class);
    Route::get('expenses/export', [ExpenseController::class, 'export'])->name('expenses.export');
    Route::resource('expenses', ExpenseController::class);
    
    // Financial Reports
    Route::get('/reports/financial', [ReportController::class, 'financial'])->name('reports.financial');
    Route::get('/reports/expenses', [ReportController::class, 'expenses'])->name('reports.expenses');
    Route::get('/reports/trips', [ReportController::class, 'trips'])->name('reports.trips');
    Route::get('/reports/fuel', [ReportController::class, 'fuel'])->name('reports.fuel');
    Route::get('/reports/projects', [ReportController::class, 'projects'])->name('reports.projects');
    
    // Route untuk ekspor laporan keuangan
    Route::get('/reports/financial/export/excel', [ReportController::class, 'exportFinancialExcel'])->name('reports.financial.export.excel');
    Route::get('/reports/financial/export/pdf', [ReportController::class, 'exportFinancialPDF'])->name('reports.financial.export.pdf');
    
    // Route untuk ekspor laporan pengeluaran
    Route::get('/reports/expenses/export/excel', [ReportController::class, 'exportExpensesExcel'])->name('reports.expenses.export.excel');
    Route::get('/reports/expenses/export/pdf', [ReportController::class, 'exportExpensesPDF'])->name('reports.expenses.export.pdf');
    
    // Route untuk ekspor laporan perjalanan
    Route::get('/reports/trips/export/excel', [ReportController::class, 'exportTripsExcel'])->name('reports.trips.export.excel');
    Route::get('/reports/trips/export/pdf', [ReportController::class, 'exportTripsPDF'])->name('reports.trips.export.pdf');
    
    // Route untuk ekspor laporan bahan bakar
    Route::get('/reports/fuel/export/excel', [ReportController::class, 'exportFuelExcel'])->name('reports.fuel.export.excel');
    Route::get('/reports/fuel/export/pdf', [ReportController::class, 'exportFuelPDF'])->name('reports.fuel.export.pdf');
    
    // Route untuk ekspor laporan proyek
    Route::get('/reports/projects/export/excel', [ReportController::class, 'exportProjectsExcel'])->name('reports.projects.export.excel');
    Route::get('/reports/projects/export/pdf', [ReportController::class, 'exportProjectsPDF'])->name('reports.projects.export.pdf');
    
    // Route untuk approval pengeluaran
    // Route untuk approval pengeluaran
    Route::patch('/expenses/{expense}/approve', [ExpenseController::class, 'approve'])->name('expenses.approve');
    Route::patch('/expenses/{expense}/reject', [ExpenseController::class, 'reject'])->name('expenses.reject');
    // Route untuk ekspor pendapatan
    Route::get('/incomes/export', [IncomeController::class, 'export'])->name('incomes.export');
    
    // Income approval routes
    Route::post('/incomes/{income}/approve', [IncomeController::class, 'approve'])->name('incomes.approve');
    Route::post('/incomes/{income}/reject', [IncomeController::class, 'reject'])->name('incomes.reject');
});
