<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'OBM System')); ?></title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        
        <!-- Select2 CSS -->
        <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
        
        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
        
        <!-- jQuery -->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <!-- Select2 JS -->
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <!-- Di bagian head, tambahkan: -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        
        <!-- Tambahkan style untuk memastikan scrolling bekerja dengan baik -->
        <style>
            body {
                overflow-y: auto; /* Ubah dari hidden menjadi auto untuk mengizinkan scrolling pada body */
                height: 100%;
                position: relative;
            }
            
            html {
                height: 100%;
            }
            
            /* Pastikan sidebar memiliki scrolling independen */
            .sidebar-container {
                height: 100vh;
                overflow-y: auto;
            }
            
            /* Pastikan konten utama memiliki scrolling independen */
            .main-content {
                min-height: 100vh;
                overflow-y: auto;
            }
            
            /* Tambahkan padding pada konten mobile untuk menghindari tertutup oleh tombol hamburger */
            @media (max-width: 768px) {
                .main-content {
                    padding-top: 3rem; /* Tambahkan padding lebih besar untuk menghindari tombol hamburger */
                }
            }
        </style>
    </head>
    <body class="font-sans antialiased">
        <!-- Ubah div utama untuk mendukung tampilan mobile dan fixed sidebar -->
        <div x-data="{ mobileMenuOpen: false }" class="min-h-screen bg-gray-100 flex flex-col md:flex-row">
            <!-- Sidebar dengan posisi fixed pada desktop dan tersembunyi pada mobile -->
            <div class="md:w-64 md:fixed md:inset-y-0 z-10">
                <!-- Sidebar untuk desktop -->
                <div class="sidebar-container md:block hidden bg-gradient-to-b from-indigo-800 to-indigo-900 h-full">
                    <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                
                <!-- Sidebar untuk mobile - akan ditampilkan saat hamburger menu diklik -->
                <div x-show="mobileMenuOpen" 
                     x-transition:enter="transition ease-out duration-200"
                     x-transition:enter-start="opacity-0 -translate-x-full"
                     x-transition:enter-end="opacity-100 translate-x-0"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100 translate-x-0"
                     x-transition:leave-end="opacity-0 -translate-x-full"
                     @click.away="mobileMenuOpen = false"
                     class="fixed inset-0 z-40 md:hidden">
                    
                    <!-- Overlay latar belakang -->
                    <div class="absolute inset-0 bg-black opacity-50" @click="mobileMenuOpen = false"></div>
                    
                    <!-- Sidebar content -->
                    <div class="relative w-3/4 max-w-xs h-full bg-gradient-to-b from-indigo-800 to-indigo-900 overflow-y-auto">
                        <?php echo $__env->make('layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                </div>
            </div>
            
            <!-- Main Content dengan margin untuk mengakomodasi fixed sidebar -->
            <div class="flex-1 md:ml-64 flex flex-col main-content">
                <!-- Tambahkan tombol hamburger untuk mobile yang akan membuka sidebar -->
                <div class="md:hidden fixed top-4 left-4 z-20">
                    <button @click="mobileMenuOpen = !mobileMenuOpen" 
                            class="p-2 rounded-md bg-indigo-600 text-white shadow-lg focus:outline-none">
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>
                
                <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <!-- Page Heading -->
                <?php if(isset($header)): ?>
                    <header class="bg-white shadow">
                        <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                            <?php echo e($header); ?>

                        </div>
                    </header>
                <?php endif; ?>

                <!-- Page Content -->
                <main class="flex-1 overflow-y-auto bg-gray-100 p-4">
                    <?php if (! empty(trim($__env->yieldContent('content')))): ?>
                        <?php echo $__env->yieldContent('content'); ?>
                    <?php else: ?>
                        <?php echo e($slot ?? ''); ?>

                    <?php endif; ?>
                </main>
            </div>
        </div>
        <?php echo $__env->yieldPushContent('scripts'); ?>
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.store('sidebar', {
                    openMenus: [],
                    init() {
                        // Inisialisasi event listener untuk menu
                        this.setupMenuHandlers();
                    },
                    setupMenuHandlers() {
                        // Pastikan event handler hanya terpasang sekali
                        document.querySelectorAll('.sidebar button').forEach(button => {
                            button.addEventListener('click', function(e) {
                                e.preventDefault(); // Tambahkan baris ini
                                e.stopPropagation();
                            });
                        });
                    },
                    closeOtherMenus(currentMenu) {
                        // Tutup semua menu dropdown kecuali yang sedang dibuka
                        document.querySelectorAll('[x-data]').forEach(el => {
                            if (el && el.__x && el !== currentMenu && el.__x.getUnobservedData().menuOpen) {
                                el.__x.updateData('menuOpen', false);
                            }
                        });
                    }
                });
            });
        </script>
    </body>
</html>
<?php /**PATH D:\wamp64\www\obm\resources\views/layouts/app.blade.php ENDPATH**/ ?>