<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1PointwiseMetricInstance extends \Google\Model
{
  protected $contentMapInstanceType = GoogleCloudAiplatformV1ContentMap::class;
  protected $contentMapInstanceDataType = '';
  /**
   * @var string
   */
  public $jsonInstance;

  /**
   * @param GoogleCloudAiplatformV1ContentMap
   */
  public function setContentMapInstance(GoogleCloudAiplatformV1ContentMap $contentMapInstance)
  {
    $this->contentMapInstance = $contentMapInstance;
  }
  /**
   * @return GoogleCloudAiplatformV1ContentMap
   */
  public function getContentMapInstance()
  {
    return $this->contentMapInstance;
  }
  /**
   * @param string
   */
  public function setJsonInstance($jsonInstance)
  {
    $this->jsonInstance = $jsonInstance;
  }
  /**
   * @return string
   */
  public function getJsonInstance()
  {
    return $this->jsonInstance;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1PointwiseMetricInstance::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1PointwiseMetricInstance');
